﻿using System;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for a particular document.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
    /// </history>
    public class DocumentViewModel
    {

        #region Properties

        /// <summary>
        /// Gets or sets the creation date of the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public DateTime CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the identifier of the organisation that created the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string Organisation { get; set; }

        /// <summary>
        /// Gets or sets the author of the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string Author { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier of the repository containing the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string RepositoryId { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier of the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string DocumentId { get; set; }

        /// <summary>
        /// Gets or sets the service start date of the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public DateTime ServiceStartDate { get; set; }

        /// <summary>
        /// Gets or sets the service end date of the document.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public DateTime ServiceEndDate { get; set; }

        /// <summary>
        /// Gets or sets the document category code.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string CategoryCode { get; set; }

        /// <summary>
        /// Gets or sets the document category description.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="10 January 2014">Initial version.</change>
        /// </history>
        public string CategoryName { get; set; }

        #endregion

    }

}